import { StrictMode } from 'react';
import { createRoot } from 'react-dom/client';
import App from './App.tsx';
import './index.css';
import { initPWAInstallPrompt } from './pwa/installPromptManager';
import { initCartPlugin } from './plugins/cart';

// Initialize Plugins
initCartPlugin();


if (typeof window !== 'undefined') {
  initPWAInstallPrompt();
}

const rootElement = document.getElementById('root');

if (rootElement) {
  createRoot(rootElement).render(
    <StrictMode>
      <App />
    </StrictMode>
  );
}

// Service worker registration is now handled by vite-plugin-pwa
// The plugin injects the registration script automatically

