# 📋 Project Specifications: SQB B2B Commerce Platform

**Version**: 1.0.1
**Last Updated**: December 20, 2025
**Status**: Active Development

---

## 1. Project Overview

The SQB B2B Commerce Platform is a versatile, multi-catalog e-commerce solution designed for **any B2B business model**. While initially piloted for the hardware sector, its core architecture is industry-agnostic, allowing businesses to manage distinct catalogs, customer-specific pricing, and complex B2B workflows for any product type.

### Key Objectives
- **Universal B2B Applicability**: Flexible catalog system adaptable to various industries (Hardware, Textiles, Electronics, FMCG, etc.).
- **Strict Catalog Isolation**: Ability to serve different customer segments (e.g., Wholesalers, Retailers, Corporate Clients) with completely separate product catalogs and pricing strategies.
- **Tunisian Market Compliance**: Native support for RNE verification, multi-tier TVA handling (19%, 7%, 0%), and tax exemptions.
- **Workflow Automation**: Automated quotation-to-order conversion, invoice generation, and stock management.

---

## 2. Technology Stack

### Backend API
- **Runtime**: Node.js v20.19.4
- **Framework**: Express.js
- **Language**: TypeScript
- **Database**: PostgreSQL
- **ORM**: Prisma
- **Authentication**: JWT (Access + Refresh Tokens)
- **File Storage**: Local filesystem (uploads directory)
- **Email Service**: Nodemailer (SMTP)

### Admin Dashboard
- **Framework**: React 18
- **Build Tool**: Vite
- **Language**: TypeScript
- **Styling**: Tailwind CSS
- **Icons**: Lucide React
- **State Management**: React Context
- **Routing**: React Router v6

### Customer Frontend
- **Framework**: React 18.3.1
- **Build Tool**: Vite
- **Language**: TypeScript
- **Styling**: Tailwind CSS
- **Routing**: React Router v7
- **PWA**: vite-plugin-pwa (Installable Web App)

---

## 3. System Architecture

### High-Level Design
The system follows a standard 3-tier architecture:
1.  **Presentation Layer**:
    *   **Customer Frontend**: Public-facing shop (requires login), catalog browsing, cart, checkout.
    *   **Admin Dashboard**: Restricted access for admins/managers to manage products, orders, customers.
2.  **Application Layer**:
    *   **Node.js/Express API**: Handles business logic, authentication, data validation, and orchestration.
3.  **Data Layer**:
    *   **PostgreSQL**: Relational database storing all persistent data.
    *   **Prisma ORM**: Type-safe database access.

### Integration Points
- **REST API**: All frontends communicate with the backend via a unified REST API (`/api/v1`).
- **Static Assets**: Images and documents served statically from the backend.

---

## 4. Core Features

### 4.1. Authentication & Authorization
- **Roles**: `ADMIN`, `MANAGER`, `CUSTOMER`.
- **Flow**: JWT-based auth with short-lived access tokens and long-lived refresh tokens.
- **Registration**:
    *   **Public**: Disabled (B2B enforcement).
    *   **Admin-Created**: Accounts created by admins with RNE verification.

### 4.2. Catalog Management
- **Universal Catalog System**: Define catalogs for any product category or business unit (e.g., "Summer Collection", "Industrial Parts", "Premium Services").
- **Catalog Isolation**: Customers are assigned specific catalogs, ensuring they only see relevant products and pricing.
- **Categories**: Flexible hierarchical category tree (Parent -> Child) adaptable to any inventory structure.
- **Products**:
    *   Multi-catalog support (same product can appear in multiple catalogs with different prices).
    *   Variant support (Size tables, Pack sizes, Colors, etc.).
    *   Flexible specifications (key-value pairs) for any product attributes.
    *   Stock tracking.

### 4.3. B2B & Financial Features
- **Quotation System**:
    *   Draft -> Pending Approval -> Approved -> Converted to Order.
    *   Admin review process with credit limit checks.
- **Credit Management**:
    *   Financial limits per customer.
    *   Outstanding balance tracking.
    *   Payment terms (`NET_30`, `NET_60`, etc.).
    *   Account status (`ACTIVE`, `SUSPENDED`, `FINANCIAL_HOLD`).
- **Taxation (Tunisia)**:
    *   TVA Rates: 19%, 7%, 0%.
    *   Exemption handling (Customer-level and Product-level).
    *   Stamp duty calculation (if applicable).

### 4.4. Order Processing
- **Order Lifecycle**: `PENDING` -> `PROCESSING` -> `SHIPPED` -> `DELIVERED`.
- **Source**: Direct checkout or converted from Quotation.
- **Invoicing**: Automatic PDF invoice generation.

### 4.5. Marketing
- **Banner Slider**: Dynamic homepage banners managed via Admin Dashboard.
- **Promotions**: Discount logic (Percentage/Fixed) with date ranges.

---

## 5. Database Schema Specifications

### User Management
- **`User`**: Stores profile, role, RNE details, financial limits, and tax exemption status.
- **`Address`**: Multiple shipping/billing addresses per user.

### Catalog & Products
- **`Catalog`**: Defines a product collection (e.g., "Hardware 2025").
- **`CatalogCustomer`**: Many-to-many link between users and catalogs.
- **`Category`**: Hierarchical organization.
- **`Product`**: Core product data (SKU, Price, Stock).
- **`ProductSizeTable`**: Variant pricing based on size/quantity.
- **`ProductPackSize`**: Packaging variants (e.g., "Box of 100").

### Transactions
- **`Quotation`**: Pre-order negotiation document.
- **`QuotationItem`**: Line items for quotes.
- **`Order`**: Confirmed purchase record.
- **`OrderItem`**: Line items for orders.
- **`OrderStatusHistory`**: Audit trail for order status changes.

---

## 6. API Specifications (Key Endpoints)

### Authentication
- `POST /api/auth/login`: Authenticate user.
- `POST /api/auth/refresh`: Refresh access token.

### Products
- `GET /api/products`: List products (filtered by assigned catalog).
- `GET /api/products/:id`: Get detailed product info.

### Quotations (B2B)
- `POST /api/quotations`: Create a new draft quote.
- `POST /api/quotations/:id/submit`: Submit for admin approval.
- `PUT /api/quotations/:id/approve`: Admin approves and converts to order.

### Orders
- `POST /api/orders`: Create order directly (if allowed).
- `GET /api/orders`: List customer orders.

---

## 7. Environment Variables

### Backend (`.env`)
```env
PORT=3001
DATABASE_URL="postgresql://user:pass@host:5432/db"
JWT_SECRET="your-secret-key"
JWT_REFRESH_SECRET="your-refresh-secret"
CORS_ORIGIN="http://localhost:5173,http://localhost:5174"
SMTP_HOST="smtp.example.com"
SMTP_USER="user@example.com"
SMTP_PASS="password"
```

### Frontend (`.env`)
```env
VITE_API_URL="http://localhost:3001/api"
```

---

## 8. Deployment Strategy

- **Infrastructure**: VPS (Ubuntu/Linux).
- **Containerization**: Docker & Docker Compose (optional but recommended).
- **Process Management**: PM2 (for Node.js) or Docker Restart Policies.
- **Web Server**: Nginx (Reverse Proxy for API and Static Files).
- **CI/CD**: Git-based deployment (Pull -> Build -> Restart).

---

*This document serves as the single source of truth for the project's technical specifications.*
