# 💾 Backend Backup - Netlify Configuration

**Date**: November 17, 2025  
**Purpose**: Backup before switching to sqb-tunisie.com full VPS deployment

---

## 📌 Backup Location on VPS

**Path**: `~/backups/backend-netlify-config-YYYYMMDD/`

**VPS**: ubuntu@51.75.143.218

---

## 📦 What's Backed Up

### **1. Complete Backend Directory**
- Source: `/var/www/smd-backend`
- Contains: Docker setup, configurations, scripts

### **2. Backend .env File**
- Source: `/var/www/smd-store/backend/.env`
- Contains: CORS configuration for Netlify domains
- **CRITICAL**: Has working CORS settings

### **3. Nginx Configuration**
- Source: Docker container `smd-nginx`
- File: `/etc/nginx/conf.d/default.conf`
- Contains: Redirect to catalogquienquillerie.sqb-tunisie.com

---

## 🏗️ Original Architecture (Netlify)

### **Frontend:**
- **Admin Dashboard**: Deployed on Netlify
- **Customer Shop**: Deployed on Netlify
- **Auto-Deploy**: Triggered on GitHub push

### **Backend:**
- **API Domain**: www.catalogquienquillerie.sqb-tunisie.com
- **Port**: 3001
- **Container**: Docker (smd-backend)
- **Database**: PostgreSQL (Docker)

### **CORS Configuration:**
```env
CORS_ORIGIN=http://localhost:5173,http://localhost:5174,https://sqb-tunisie.com,https://www.sqb-tunisie.com,https://www.catalogquienquillerie.sqb-tunisie.com,https://[netlify-admin-url],https://[netlify-customer-url]
```

---

## 🔄 New Architecture (Full VPS)

### **Frontend:**
- **Admin Dashboard**: sqb-tunisie.com/admin (VPS)
- **Customer Shop**: sqb-tunisie.com/customer (VPS)
- **Served by**: Nginx on VPS

### **Backend:**
- **API Domain**: www.catalogquienquillerie.sqb-tunisie.com
- **Port**: 3001
- **Container**: Docker (same)
- **Database**: PostgreSQL (same)

### **New CORS Configuration:**
```env
CORS_ORIGIN=https://sqb-tunisie.com,https://www.sqb-tunisie.com,https://www.catalogquienquillerie.sqb-tunisie.com
```

---

## 🔙 How to Restore Netlify Setup

If you need to go back to Netlify deployment:

### **Step 1: On VPS**
```bash
# SSH to VPS
ssh ubuntu@51.75.143.218

# Navigate to backup
cd ~/backups/backend-netlify-config-YYYYMMDD/

# Stop current backend
cd /var/www/smd-backend
docker-compose down

# Restore backend directory
sudo cp -r ~/backups/backend-netlify-config-YYYYMMDD/smd-backend /var/www/

# Restore .env file
sudo cp ~/backups/backend-netlify-config-YYYYMMDD/backend-env-backup /var/www/smd-store/backend/.env

# Restart backend
cd /var/www/smd-backend
docker-compose up -d

# Verify
curl http://localhost:3001/health
```

### **Step 2: Redeploy to Netlify**
```bash
# On local machine
cd /path/to/SmartCatalogueproject

# Update .env.production files to point to Netlify URLs
# (Remove base paths from vite.config.ts if needed)

# Build and deploy to Netlify
npm run build
# Upload dist/ to Netlify

cd admin-dashboard
npm run build
# Upload dist/ to Netlify
```

### **Step 3: Update DNS (if needed)**
- Point frontend domains back to Netlify
- Keep backend API on VPS

---

## 📋 Backup Verification Checklist

- [x] Backend directory backed up
- [x] .env file backed up
- [x] Nginx config backed up
- [x] README created in backup folder
- [x] Backup documented locally

---

## 🚨 Important Notes

1. **Keep this backup** - Don't delete it
2. **CORS settings** - The .env file has working CORS for Netlify
3. **Database** - Database is NOT backed up here (it's shared between setups)
4. **SSL Certificates** - May need to reconfigure if switching back
5. **Nginx** - Will need to update nginx config when switching back

---

## 📞 Quick Reference

### **Backup Location:**
```
VPS: ~/backups/backend-netlify-config-YYYYMMDD/
```

### **Original CORS (Netlify):**
```
Includes Netlify domains
```

### **New CORS (Full VPS):**
```
Only sqb-tunisie.com domains
```

---

**Created**: November 17, 2025  
**Status**: Backup complete ✅  
**Safe to proceed**: YES - We can now configure for full VPS deployment
