import { PrismaClient } from '@prisma/client';
import bcrypt from 'bcryptjs';
const prisma = new PrismaClient();
async function resetPassword() {
    const email = 'admin@smd-tunisie.com';
    const newPassword = 'admin123';
    console.log(`Resetting password for ${email}...`);
    try {
        const passwordHash = await bcrypt.hash(newPassword, 10);
        const user = await prisma.user.update({
            where: { email },
            data: {
                passwordHash,
                isActive: true // Ensure account is active
            }
        });
        console.log(`✅ Password reset successfully for user: ${user.email}`);
        console.log(`   New Password: ${newPassword}`);
    }
    catch (error) {
        console.error('❌ Password reset failed:', error);
    }
}
resetPassword()
    .catch(console.error)
    .finally(() => prisma.$disconnect());
//# sourceMappingURL=reset-admin-password.js.map