import { Router } from 'express';
import { getSettings, updateSettings } from '../controllers/settings.controller.js';
import { authenticate, authorize, PERMISSIONS } from '../middleware/auth.js';
const router = Router();
// Get settings - Protected (Admin/Manager)
router.get('/', authenticate, authorize(...PERMISSIONS.SETTINGS_MANAGE), getSettings);
// Update settings - Protected (Admin/Manager)
router.post('/', authenticate, authorize(...PERMISSIONS.SETTINGS_MANAGE), updateSettings);
export default router;
//# sourceMappingURL=settings.routes.js.map