import express from 'express';
import { authenticateToken, requireRole } from '../middleware/auth.js';
import { getPlugins, togglePlugin } from '../controllers/plugin.controller.js';
const router = express.Router();
// Protected Routes (Admin Only)
router.use(authenticateToken);
router.use(requireRole(['ADMIN', 'SUPER_ADMIN']));
router.get('/', getPlugins);
router.post('/:name/toggle', togglePlugin);
export default router;
//# sourceMappingURL=plugin.routes.js.map