import { Router } from 'express';
import { getCatalogs, getCatalogById, createCatalog, updateCatalog, } from '../controllers/catalog.controller.js';
import { authenticate, authorize } from '../middleware/auth.js';
const router = Router();
// Public catalog info
router.get('/', getCatalogs);
router.get('/:id', getCatalogById);
// Admin catalog management
router.post('/', authenticate, authorize('ADMIN', 'MANAGER'), createCatalog);
router.put('/:id', authenticate, authorize('ADMIN', 'MANAGER'), updateCatalog);
export default router;
//# sourceMappingURL=catalog.routes.js.map