import prisma from '../config/database.js';
import { createError } from '../middleware/errorHandler.js';
// Update user language preference
export const updateLanguage = async (req, res, next) => {
    try {
        if (!req.user) {
            throw createError('Not authenticated', 401);
        }
        const { language } = req.body;
        if (!language || !['en', 'fr'].includes(language)) {
            throw createError('Invalid language. Must be "en" or "fr"', 400);
        }
        const user = await prisma.user.update({
            where: { id: req.user.id },
            data: { language },
            select: {
                id: true,
                email: true,
                language: true
            }
        });
        res.json({
            success: true,
            data: user,
            message: 'Language preference updated successfully'
        });
    }
    catch (error) {
        next(error);
    }
};
//# sourceMappingURL=users.controller.js.map