
import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function checkAdmin() {
    const email = 'admin@smd-tunisie.com';
    const user = await prisma.user.findUnique({
        where: { email }
    });

    if (user) {
        console.log(`✅ Admin user found: ${user.email}`);
        console.log(`   Role: ${user.role}`);
        console.log(`   ID: ${user.id}`);
        // We can't see the password hash, but we confirm existence.
    } else {
        console.log(`❌ Admin user NOT found: ${email}`);
    }
}

checkAdmin()
    .catch(console.error)
    .finally(() => prisma.$disconnect());
