import { Router } from 'express';
import { authenticate, authorize } from '../middleware/auth.js';
import {
  getDashboardStats,
  getRecentOrders,
  getLowStockProducts,
} from '../controllers/dashboard.controller.js';

const router = Router();

router.get('/stats', authenticate, authorize('ADMIN', 'MANAGER'), getDashboardStats);
router.get('/recent-orders', authenticate, authorize('ADMIN', 'MANAGER'), getRecentOrders);
router.get('/low-stock', authenticate, authorize('ADMIN', 'MANAGER'), getLowStockProducts);

export default router;
