import { Router } from 'express';
import { listAdmins, createAdmin, updateAdminRole, deleteAdmin } from '../controllers/admin.controller.js';
import { authenticate, authorize } from '../middleware/auth.js';

const router = Router();

// All routes require authentication and SUPER_ADMIN role (or ADMIN for legacy compatibility)
// We treat 'ADMIN' as Super Admin for now to avoid breaking existing users
router.use(authenticate);
router.use(authorize('SUPER_ADMIN', 'ADMIN'));

router.get('/', listAdmins);
router.post('/', createAdmin);
router.put('/:id/role', updateAdminRole);
router.delete('/:id', deleteAdmin);

export default router;
