import prisma from './src/config/database.js';
import bcrypt from 'bcryptjs';

async function resetPassword() {
    try {
        const email = 'admin@smd-tunisie.com';
        const newPassword = 'admin123';

        // Hash password
        const passwordHash = await bcrypt.hash(newPassword, 10);

        // Update user
        const user = await prisma.user.update({
            where: { email },
            data: { passwordHash }
        });

        console.log(`✅ Password for ${user.email} has been reset to: ${newPassword}`);

        // Also reset super admin just in case
        const superAdminEmail = 'sofien@admin.com';
        const superAdmin = await prisma.user.findUnique({ where: { email: superAdminEmail } });

        if (superAdmin) {
            await prisma.user.update({
                where: { email: superAdminEmail },
                data: { passwordHash }
            });
            console.log(`✅ Password for ${superAdminEmail} has been reset to: ${newPassword}`);
        }

    } catch (error) {
        console.error('❌ Error resetting password:', error);
    } finally {
        await prisma.$disconnect();
    }
}

resetPassword();
