import { Router } from 'express';
import {
  getAllProducts,
  getProductById,
  createProduct,
  updateProduct,
  deleteProduct,
  getProductsByCategory,
  searchProducts,
  getFeaturedProducts,
  updateProductStock,
  addProductSizeTable,
  updateProductSizeTable,
  deleteProductSizeTable,
} from '../controllers/product.controller.js';
import { authenticate, authorize, PERMISSIONS } from '../middleware/auth.js';

const router = Router();

// Public routes
router.get('/', getAllProducts);
router.get('/search', searchProducts);
router.get('/featured', getFeaturedProducts);
router.get('/category/:categoryId', getProductsByCategory);
router.get('/:id', getProductById);

// Protected routes (Admin only)
router.post('/', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), createProduct);
router.put('/:id', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), updateProduct);
router.delete('/:id', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), deleteProduct);
router.patch('/:id/stock', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), updateProductStock);

// Size table routes
router.post('/:id/size-table', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), addProductSizeTable);
router.put('/:id/size-table/:sizeId', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), updateProductSizeTable);
router.delete('/:id/size-table/:sizeId', authenticate, authorize(...PERMISSIONS.CATALOG_MANAGE), deleteProductSizeTable);

export default router;
