-- Manual Seed Script for Multi-Catalog
-- Run this with: psql -U smd_user_test -d smd_hardware_test -h localhost -f prisma/seed-manual.sql

-- Create default catalog
INSERT INTO catalogs (id, name, slug, description, is_active, is_default, created_at, updated_at)
VALUES (
  gen_random_uuid(),
  'Main Catalog',
  'main',
  'Default product catalog for all existing products',
  true,
  true,
  NOW(),
  NOW()
)
ON CONFLICT (slug) DO NOTHING;

-- Update all categories to belong to default catalog
UPDATE categories 
SET catalog_id = (SELECT id FROM catalogs WHERE slug = 'main')
WHERE catalog_id IS NULL;

-- Update all products to belong to default catalog
UPDATE products 
SET catalog_id = (SELECT id FROM catalogs WHERE slug = 'main')
WHERE catalog_id IS NULL;

-- Update all banner_slides to belong to default catalog (if any exist)
UPDATE banner_slides 
SET catalog_id = (SELECT id FROM catalogs WHERE slug = 'main')
WHERE catalog_id IS NULL;

-- Assign all customers to default catalog
INSERT INTO catalog_customers (id, catalog_id, customer_id, can_order, can_quote, assigned_at)
SELECT 
  gen_random_uuid(),
  (SELECT id FROM catalogs WHERE slug = 'main'),
  id,
  true,
  true,
  NOW()
FROM users 
WHERE role = 'CUSTOMER'
ON CONFLICT (catalog_id, customer_id) DO NOTHING;

-- Display results
SELECT 'Seeding Complete!' as status;
SELECT 'Catalogs:' as table_name, COUNT(*) as count FROM catalogs
UNION ALL
SELECT 'Categories with catalog:', COUNT(*) FROM categories WHERE catalog_id IS NOT NULL
UNION ALL
SELECT 'Products with catalog:', COUNT(*) FROM products WHERE catalog_id IS NOT NULL
UNION ALL
SELECT 'Banner slides with catalog:', COUNT(*) FROM banner_slides WHERE catalog_id IS NOT NULL
UNION ALL
SELECT 'Customer assignments:', COUNT(*) FROM catalog_customers;
