# 🏗️ Infrastructure & Deployment Specification

**Version**: 1.1.0
**Last Updated**: December 20, 2025
**Status**: Active Standard

---

## 1. Deployment Architecture

The SQB B2B Platform utilizes a **traditional VPS deployment** using **PM2** for process management and **Nginx** as a reverse proxy. This architecture ensures stability, ease of monitoring, and direct control over system resources on the OVH VPS.

### High-Level Diagram
```mermaid
graph TD
    User[User / Internet] -->|HTTPS:443| Nginx[Nginx Web Server]
    
    subgraph OVH VPS
        Nginx -->|/api| Backend[Backend API (Node.js/PM2)]
        Nginx -->|/admin| Admin[Admin Dashboard (Static)]
        Nginx -->|/| Customer[Customer Frontend (Static)]
        
        Backend -->|TCP:5432| DB[PostgreSQL Database]
    end
    
    Volume1[Local Storage] -.-> DB
    Volume2[Uploads Directory] -.-> Backend
```

---

## 2. Infrastructure Requirements

### 2.1. Server Specifications
- **Provider**: **OVH VPS**
- **OS**: Ubuntu 22.04 LTS
- **CPU**: 2 vCPUs minimum
- **RAM**: 4GB minimum
- **Storage**: 20GB SSD minimum
- **IP Address**: Static Public IP (e.g., `51.75.143.218`)

### 2.2. Software Prerequisites
- **Node.js**: v20.x LTS
- **Process Manager**: PM2 (`npm install -g pm2`)
- **Database**: PostgreSQL 15+
- **Web Server**: Nginx
- **Version Control**: Git

---

## 3. Core Services

### 3.1. Backend API
- **Runtime**: Node.js via PM2
- **Process Name**: `smd-backend`
- **Port**: `3001` (Internal)
- **Directory**: `/var/www/smd-store/backend`
- **Environment**: Production (`NODE_ENV=production`)

### 3.2. Database
- **Engine**: PostgreSQL
- **Port**: `5432`
- **User**: `smd_admin`
- **Database**: `smd_hardware`
- **Access**: Localhost only (secured via `pg_hba.conf`)

### 3.3. Frontend Applications
- **Customer Shop**:
    - **Type**: Static React Build
    - **Path**: `/var/www/smd-store/dist`
    - **Domain**: `www.catalogquienquillerie.sqb-tunisie.com`
- **Admin Dashboard**:
    - **Type**: Static React Build
    - **Path**: `/var/www/smd-store/admin-dashboard/dist`
    - **Domain**: `www.sqb-tunisie.com`

### 3.4. Reverse Proxy (Nginx)
- **Role**: SSL Termination, Routing, Static File Serving.
- **Config Path**: `/etc/nginx/sites-available/smd-store`
- **SSL**: Let's Encrypt (Certbot)

---

## 4. Network & Security

### 4.1. Firewall Rules (UFW)
| Port | Protocol | Purpose |
|------|----------|---------|
| 22 | TCP | SSH Access (Restricted) |
| 80 | TCP | HTTP (Auto-redirect to HTTPS) |
| 443 | TCP | HTTPS (Main Traffic) |
| 3001 | TCP | Blocked (Internal API) |
| 5432 | TCP | Blocked (Internal DB) |

### 4.2. Security Measures
- **SSL/TLS**: Enforced HTTPS via Certbot.
- **Secrets**: Stored in `.env` files, never committed to Git.
- **Database Access**: Restricted to localhost.
- **Process Recovery**: PM2 configured to auto-restart on failure and system boot (`pm2 startup`).

---

## 5. Deployment Procedures

### 5.1. Initial Setup
1.  **System Update**: `apt update && apt upgrade`
2.  **Install Stack**: Node.js, PostgreSQL, Nginx, PM2, Git.
3.  **Clone Repo**: `git clone <repo> /var/www/smd-store`
4.  **Install Dependencies**: `npm install` in backend and frontend dirs.
5.  **Build Projects**: `npm run build` for all components.
6.  **Start Backend**: `pm2 start dist/index.js --name smd-backend`

### 5.2. Update Workflow
1.  **Pull Changes**: `git pull origin main`
2.  **Backend Update**:
    - `npm install` (if package.json changed)
    - `npx prisma migrate deploy` (if schema changed)
    - `npm run build`
    - `pm2 restart smd-backend`
3.  **Frontend Update**:
    - `npm install`
    - `npm run build` (Nginx serves new files immediately)

### 5.3. Backup Strategy
- **Database**: Daily cron job executing `pg_dump`.
- **Files**: Regular backups of `/var/www/smd-store` and `/etc/nginx`.

---

## 6. Monitoring & Maintenance

- **Process Status**: `pm2 status`
- **Logs**:
    - Backend: `pm2 logs smd-backend`
    - Nginx: `/var/log/nginx/error.log`
- **Resource Usage**: `pm2 monit`

---

*This specification defines the standard for the OVH VPS production deployment using PM2.*
