import express from 'express';
import multer from 'multer';
import path from 'path';
import { authenticate, authorize } from '../middleware/auth.js';
import { getPlugins, togglePlugin, getNavigation, getPluginConfig, updatePluginConfig, uploadPlugin } from '../controllers/plugin.controller.js';

const router = express.Router();

// Multer Setup
const storage = multer.diskStorage({
    destination: (req, file, cb) => {
        cb(null, 'uploads/'); // Temporary upload dir
    },
    filename: (req, file, cb) => {
        cb(null, `plugin-${Date.now()}${path.extname(file.originalname)}`);
    }
});

const upload = multer({ storage });

// Protected Routes (Admin Only)
router.use(authenticate);
router.use(authorize('ADMIN', 'SUPER_ADMIN'));

router.get('/', getPlugins);
router.get('/navigation', getNavigation);
router.post('/:name/toggle', togglePlugin);
router.get('/:name/config', getPluginConfig);
router.put('/:name/config', updatePluginConfig);
router.post('/upload', upload.single('plugin'), uploadPlugin);

export default router;
