
const { PrismaClient } = require('@prisma/client');
const bcrypt = require('bcryptjs');
const prisma = new PrismaClient();

async function main() {
    try {
        const email = 'admin@smd-tunisie.com';
        const newPassword = 'admin123';
        const hashedPassword = await bcrypt.hash(newPassword, 10);

        const updatedUser = await prisma.user.update({
            where: { email: email },
            data: { passwordHash: hashedPassword }
        });

        console.log(`✅ Password for ${updatedUser.email} has been reset to: ${newPassword}`);
    } catch (e) {
        console.error('❌ Error resetting password:', e);
    } finally {
        await prisma.$disconnect();
    }
}

main();
