
const { PrismaClient } = require('@prisma/client');
const prisma = new PrismaClient();

async function main() {
    try {
        console.log('--- CATALOGS IN DATABASE ---');
        const catalogs = await prisma.catalog.findMany();

        if (catalogs.length === 0) {
            console.log('NO CATALOGS FOUND.');
        } else {
            console.table(catalogs);
        }
    } catch (e) {
        console.error('Error fetching catalogs:', e);
    } finally {
        await prisma.$disconnect();
    }
}

main();
