/**
 * Tunisian TVA rates (as percentages)
 */
export declare const TVA_RATES: {
    readonly STANDARD: 19;
    readonly REDUCED: 7;
    readonly EXEMPT: 0;
};
/**
 * Get effective TVA rate for a product in a specific catalog
 * Checks catalog-specific overrides first, then falls back to product default
 */
export declare function getEffectiveTvaRate(productId: string, catalogId: string): Promise<{
    rate: number;
    exempt: boolean;
    reason?: string;
}>;
/**
 * Line item TVA calculation input
 */
export interface LineItemTva {
    quantity: number;
    unitPrice: number;
    discount?: number;
    tvaRate: number;
    tvaExempt: boolean;
    fodecSubject?: boolean;
}
/**
 * Line item TVA calculation result
 */
export interface LineItemTvaResult {
    totalBrutHT: number;
    discount: number;
    totalNetHT: number;
    fodecAmount: number;
    tvaBase: number;
    tvaRate: number;
    tvaAmount: number;
    totalTTC: number;
    tvaExempt: boolean;
}
/**
 * Calculate TVA for a single line item
 */
export declare function calculateLineItemTva(item: LineItemTva): LineItemTvaResult;
/**
 * Document-level TVA summary
 */
export interface DocumentTvaSummary {
    totalBrutHT: number;
    totalDiscount: number;
    totalNetHT: number;
    totalFodec: number;
    tva19Amount: number;
    tva7Amount: number;
    tva0Amount: number;
    totalTVA: number;
    netAPayer: number;
    netAPayerWords: string;
}
export declare function calculateDocumentTva(lineItems: LineItemTvaResult[]): DocumentTvaSummary;
/**
 * Convert number to French words for invoices
 * Example: 1234.56 → "Mille deux cent trente-quatre dinars et cinquante-six millimes"
 */
export declare function numberToFrenchWords(amount: number): string;
/**
 * Check if customer is TVA exempt
 */
export declare function isCustomerTvaExempt(userId: string): Promise<boolean>;
/**
 * Format amount for display
 */
export declare function formatTvaAmount(amount: number): string;
/**
 * Get TVA rate label in French
 */
export declare function getTvaRateLabel(rate: number): string;
//# sourceMappingURL=tvaCalculations.d.ts.map