"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateMargin = exports.calculateFiscalTotals = void 0;
/**
 * Calculates fiscal totals for a list of items.
 * Handles Decimal or number inputs safely.
 */
const calculateFiscalTotals = (items, timbreFiscal = 1.000) => {
    let totalHT = 0;
    let totalTVA = 0;
    items.forEach(item => {
        const price = Number(item.unitPrice);
        const qty = Number(item.quantity);
        const tva = Number(item.tvaRate);
        const discount = Number(item.discount || 0);
        // Calculate line HT (after discount)
        const lineTotalHT = (price * qty) - discount;
        // Calculate line TVA
        const lineTVA = lineTotalHT * (tva / 100);
        totalHT += lineTotalHT;
        totalTVA += lineTVA;
    });
    // Round to 3 decimal places (Tunisian standard)
    totalHT = Math.round(totalHT * 1000) / 1000;
    totalTVA = Math.round(totalTVA * 1000) / 1000;
    const totalTTC = totalHT + totalTVA + timbreFiscal;
    return {
        totalHT,
        totalTVA,
        totalTTC: Math.round(totalTTC * 1000) / 1000
    };
};
exports.calculateFiscalTotals = calculateFiscalTotals;
/**
 * Calculates margin for a single product sale
 */
const calculateMargin = (sellingPriceHT, costPrice, quantity) => {
    const margin = (sellingPriceHT - costPrice) * quantity;
    return Math.round(margin * 1000) / 1000;
};
exports.calculateMargin = calculateMargin;
//# sourceMappingURL=fiscal.js.map