/**
 * Discount calculation utilities for product pricing
 */
/**
 * Discount information for a product
 */
export interface DiscountInfo {
    hasDiscount: boolean;
    discountType?: 'percentage' | 'fixed';
    discountValue?: number;
    originalPrice: number;
    discountAmount: number;
    finalPrice: number;
    savings: number;
    isActive: boolean;
}
/**
 * Calculate product discount and final price
 *
 * @param basePrice - Original product price
 * @param hasDiscount - Whether discount is enabled
 * @param discountType - Type of discount: "percentage" or "fixed"
 * @param discountValue - Discount value (percentage or fixed amount)
 * @param discountStartDate - Optional start date for discount
 * @param discountEndDate - Optional end date for discount
 * @returns DiscountInfo object with all calculated values
 */
export declare function calculateProductDiscount(basePrice: number | any, hasDiscount: boolean, discountType?: string | null, discountValue?: number | any | null, discountStartDate?: Date | null, discountEndDate?: Date | null): DiscountInfo;
/**
 * Format discount for display (e.g., "15.0 %" or "50.00 DT")
 */
export declare function formatDiscount(discountType?: string | null, discountValue?: number | any | null): string;
/**
 * Calculate discount amount for a line item
 * Used in quotations and orders
 */
export declare function calculateLineDiscount(quantity: number, unitPrice: number, discountType?: string | null, discountValue?: number | any | null): number;
/**
 * Check if a discount is currently active
 */
export declare function isDiscountActive(hasDiscount: boolean, discountStartDate?: Date | null, discountEndDate?: Date | null): boolean;
//# sourceMappingURL=discountCalculations.d.ts.map