"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const upload_controller_1 = require("../controllers/upload.controller");
const upload_service_1 = require("../services/upload.service");
const auth_1 = require("../middleware/auth");
const router = (0, express_1.Router)();
// All upload routes require authentication (admin/manager only)
router.post('/image', auth_1.authenticate, (0, auth_1.authorize)('ADMIN', 'MANAGER'), upload_service_1.upload.single('image'), upload_controller_1.uploadImage);
router.post('/images', auth_1.authenticate, (0, auth_1.authorize)('ADMIN', 'MANAGER'), upload_service_1.upload.array('images', 10), upload_controller_1.uploadMultipleImages);
router.delete('/image', auth_1.authenticate, (0, auth_1.authorize)('ADMIN', 'MANAGER'), upload_controller_1.deleteImage);
exports.default = router;
//# sourceMappingURL=upload.routes.js.map