"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const settings_controller_js_1 = require("../controllers/settings.controller.js");
const auth_js_1 = require("../middleware/auth.js");
const router = (0, express_1.Router)();
// Get settings - Protected (Admin/Manager)
router.get('/', auth_js_1.authenticate, (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.SETTINGS_MANAGE), settings_controller_js_1.getSettings);
// Update settings - Protected (Admin/Manager)
router.post('/', auth_js_1.authenticate, (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.SETTINGS_MANAGE), settings_controller_js_1.updateSettings);
exports.default = router;
//# sourceMappingURL=settings.routes.js.map