"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const product_controller_js_1 = require("../controllers/product.controller.js");
const auth_js_1 = require("../middleware/auth.js");
const router = (0, express_1.Router)();
// Public routes
router.get('/', product_controller_js_1.getAllProducts);
router.get('/search', product_controller_js_1.searchProducts);
router.get('/featured', product_controller_js_1.getFeaturedProducts);
router.get('/category/:categoryId', product_controller_js_1.getProductsByCategory);
router.get('/:id', product_controller_js_1.getProductById);
// Protected routes (Admin only)
router.post('/', auth_js_1.authenticate, (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.CATALOG_MANAGE), product_controller_js_1.createProduct);
router.put('/:id', auth_js_1.authenticate, (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.CATALOG_MANAGE), product_controller_js_1.updateProduct);
router.delete('/:id', auth_js_1.authenticate, (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.CATALOG_MANAGE), product_controller_js_1.deleteProduct);
router.patch('/:id/stock', auth_js_1.authenticate, (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.CATALOG_MANAGE), product_controller_js_1.updateProductStock);
// Size table routes
router.post('/:id/size-table', auth_js_1.authenticate, (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.CATALOG_MANAGE), product_controller_js_1.addProductSizeTable);
router.put('/:id/size-table/:sizeId', auth_js_1.authenticate, (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.CATALOG_MANAGE), product_controller_js_1.updateProductSizeTable);
router.delete('/:id/size-table/:sizeId', auth_js_1.authenticate, (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.CATALOG_MANAGE), product_controller_js_1.deleteProductSizeTable);
exports.default = router;
//# sourceMappingURL=product.routes.js.map