"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const auth_js_1 = require("../middleware/auth.js");
const dashboard_controller_js_1 = require("../controllers/dashboard.controller.js");
const router = (0, express_1.Router)();
router.get('/stats', auth_js_1.authenticate, (0, auth_js_1.authorize)('ADMIN', 'MANAGER'), dashboard_controller_js_1.getDashboardStats);
router.get('/recent-orders', auth_js_1.authenticate, (0, auth_js_1.authorize)('ADMIN', 'MANAGER'), dashboard_controller_js_1.getRecentOrders);
router.get('/low-stock', auth_js_1.authenticate, (0, auth_js_1.authorize)('ADMIN', 'MANAGER'), dashboard_controller_js_1.getLowStockProducts);
exports.default = router;
//# sourceMappingURL=dashboard.routes.js.map