"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const auth_js_1 = require("../middleware/auth.js");
const customer_controller_js_1 = require("../controllers/customer.controller.js");
const router = (0, express_1.Router)();
// All routes require authentication
router.use(auth_js_1.authenticate);
// View routes (Support can view)
router.get('/', (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.CUSTOMER_VIEW), customer_controller_js_1.getAllCustomers);
router.get('/:id', (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.CUSTOMER_VIEW), customer_controller_js_1.getCustomerById);
// Manage routes (Sales/Admin only)
router.post('/', (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.CUSTOMER_MANAGE), customer_controller_js_1.createCustomer);
router.put('/:id', (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.CUSTOMER_MANAGE), customer_controller_js_1.updateCustomer);
router.delete('/:id', (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.CUSTOMER_MANAGE), customer_controller_js_1.deleteCustomer);
router.post('/:id/reset-password', (0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.CUSTOMER_MANAGE), customer_controller_js_1.resetCustomerPassword);
exports.default = router;
//# sourceMappingURL=customer.routes.js.map