"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const category_controller_1 = require("../controllers/category.controller");
const auth_1 = require("../middleware/auth");
const router = (0, express_1.Router)();
// Public routes (no authentication required)
router.get('/', category_controller_1.getAllCategories);
router.get('/:id', category_controller_1.getCategoryById);
router.get('/:parentId/subcategories', category_controller_1.getSubcategories);
router.get('/:id/products', category_controller_1.getCategoryProducts);
// Protected routes (admin only)
router.post('/', auth_1.authenticate, (0, auth_1.authorize)(...auth_1.PERMISSIONS.CATALOG_MANAGE), category_controller_1.createCategory);
router.put('/:id', auth_1.authenticate, (0, auth_1.authorize)(...auth_1.PERMISSIONS.CATALOG_MANAGE), category_controller_1.updateCategory);
router.delete('/:id', auth_1.authenticate, (0, auth_1.authorize)(...auth_1.PERMISSIONS.CATALOG_MANAGE), category_controller_1.deleteCategory);
exports.default = router;
//# sourceMappingURL=category.routes.js.map