"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const catalog_controller_js_1 = require("../controllers/catalog.controller.js");
const auth_js_1 = require("../middleware/auth.js");
const router = (0, express_1.Router)();
// Public catalog info
router.get('/', catalog_controller_js_1.getCatalogs);
router.get('/:id', catalog_controller_js_1.getCatalogById);
// Admin catalog management
router.post('/', auth_js_1.authenticate, (0, auth_js_1.authorize)('ADMIN', 'MANAGER'), catalog_controller_js_1.createCatalog);
router.put('/:id', auth_js_1.authenticate, (0, auth_js_1.authorize)('ADMIN', 'MANAGER'), catalog_controller_js_1.updateCatalog);
exports.default = router;
//# sourceMappingURL=catalog.routes.js.map