"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const auth_controller_js_1 = require("../controllers/auth.controller.js");
const users_controller_js_1 = require("../controllers/users.controller.js");
const auth_js_1 = require("../middleware/auth.js");
const router = (0, express_1.Router)();
// Public routes
router.post('/register', auth_controller_js_1.register);
router.post('/login', auth_controller_js_1.login);
router.post('/refresh-token', auth_controller_js_1.refreshToken);
router.post('/forgot-password', auth_controller_js_1.forgotPassword);
router.post('/reset-password', auth_controller_js_1.resetPassword);
// Protected routes
router.post('/logout', auth_js_1.authenticate, auth_controller_js_1.logout);
router.get('/me', auth_js_1.authenticate, auth_controller_js_1.getCurrentUser);
router.patch('/me/language', auth_js_1.authenticate, users_controller_js_1.updateLanguage);
exports.default = router;
//# sourceMappingURL=auth.routes.js.map