"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const accounting_controller_js_1 = require("../controllers/accounting.controller.js");
const auth_js_1 = require("../middleware/auth.js");
const router = (0, express_1.Router)();
// All routes require Admin access
router.use(auth_js_1.authenticate);
router.use((0, auth_js_1.authorize)(...auth_js_1.PERMISSIONS.ACCOUNTING_VIEW));
/**
 * @route   GET /api/admin/accounting/stats
 * @desc    Get monthly fiscal statistics
 * @access  Admin
 */
router.get('/stats', accounting_controller_js_1.getAccountingStats);
exports.default = router;
//# sourceMappingURL=accounting.routes.js.map