"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.init = exports.navigation = exports.description = exports.version = exports.name = void 0;
const logic = __importStar(require("./logic.js"));
exports.name = 'tax-tunisia';
exports.version = '1.0.0';
exports.description = 'Tunisian Tax System (19%, 7%, FODEC)';
exports.navigation = [
    {
        name: 'Tax Configuration',
        href: '/settings/taxes', // We will reuse settings for now or create new
        icon: 'Calculator', // String name of icon
        roles: ['SUPER_ADMIN', 'ADMIN', 'ACCOUNTING_ADMIN']
    }
];
const init = async (app, hooks) => {
    // Helper to get current config
    const getConfig = async () => {
        const pm = app.get('pluginManager');
        const config = await pm.getPluginConfig('tax-tunisia');
        // Merge with defaults
        return {
            standardRate: 19,
            reducedRate: 7,
            fodecRate: 1,
            enableStamp: true,
            stampValue: 1.000,
            ...config
        };
    };
    // Hook: calculate.line_item
    // Context: LineItemInput & { result?: LineItemResult }
    hooks.on('calculate.line_item', async (context, next) => {
        try {
            const config = await getConfig();
            // Apply Tunisian Tax Logic with Config
            const result = logic.calculateLineItem(context, config);
            context.result = result;
        }
        catch (error) {
            console.error('[TaxTunisia] Error in calculate.line_item:', error);
            throw error;
        }
        await next();
    });
    // Hook: calculate.document
    // Context: { lineItems: LineItemResult[], result?: DocumentTvaSummary }
    hooks.on('calculate.document', async (context, next) => {
        try {
            const config = await getConfig();
            const result = logic.calculateDocumentTva(context.lineItems, config);
            context.result = result;
        }
        catch (error) {
            console.error('[TaxTunisia] Error in calculate.document:', error);
            throw error;
        }
        await next();
    });
    // Hook: tva.get_effective_rate
    // Context: { productId: string, catalogId: string, result?: { rate: number, ... } }
    hooks.on('tva.get_effective_rate', async (context, next) => {
        try {
            const result = await logic.getEffectiveTvaRate(context.productId, context.catalogId);
            context.result = result;
        }
        catch (error) {
            console.error('[TaxTunisia] Error in tva.get_effective_rate:', error);
        }
        await next();
    });
    // Hook: tva.is_exempt
    // Context: { userId: string, isExempt?: boolean }
    hooks.on('tva.is_exempt', async (context, next) => {
        try {
            context.isExempt = await logic.isCustomerTvaExempt(context.userId);
        }
        catch (error) {
            console.error('[TaxTunisia] Error in tva.is_exempt:', error);
        }
        await next();
    });
    console.log('[TaxTunisia] Plugin initialized');
};
exports.init = init;
//# sourceMappingURL=index.js.map