"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginManager = void 0;
const HookSystem_js_1 = require("./HookSystem.js");
const promises_1 = __importDefault(require("fs/promises"));
const path_1 = __importDefault(require("path"));
class PluginManager {
    plugins = [];
    app;
    stateFile = path_1.default.join(process.cwd(), 'data', 'plugins.json');
    states = {};
    constructor(app) {
        this.app = app;
    }
    /**
     * Register a plugin manually
     */
    register(plugin) {
        this.plugins.push(plugin);
        console.log(`[PluginManager] Registered plugin: ${plugin.name} v${plugin.version}`);
    }
    async loadStates() {
        try {
            await promises_1.default.mkdir(path_1.default.dirname(this.stateFile), { recursive: true });
            const data = await promises_1.default.readFile(this.stateFile, 'utf-8');
            const parsed = JSON.parse(data);
            this.states = parsed.reduce((acc, curr) => ({ ...acc, [curr.name]: curr.enabled }), {});
        }
        catch (error) {
            console.log('[PluginManager] No plugin state file found, creating default.');
            this.states = {};
        }
    }
    async saveStates() {
        const data = Object.entries(this.states).map(([name, enabled]) => ({ name, enabled }));
        await promises_1.default.writeFile(this.stateFile, JSON.stringify(data, null, 2));
    }
    /**
     * Initialize all registered plugins
     */
    configFile = path_1.default.join(process.cwd(), 'data', 'plugin-configs.json');
    configs = {};
    async loadConfigs() {
        try {
            const data = await promises_1.default.readFile(this.configFile, 'utf-8');
            this.configs = JSON.parse(data);
        }
        catch (error) {
            console.log('[PluginManager] No plugin config file found, creating default.');
            this.configs = {};
        }
    }
    async saveConfigs() {
        await promises_1.default.writeFile(this.configFile, JSON.stringify(this.configs, null, 2));
    }
    async init() {
        await this.loadStates();
        await this.loadConfigs();
        console.log('[PluginManager] Initializing plugins...');
        for (const plugin of this.plugins) {
            // Default to enabled if not in state
            if (this.states[plugin.name] === undefined) {
                this.states[plugin.name] = true;
            }
            if (!this.states[plugin.name]) {
                console.log(`[PluginManager] Skipping disabled plugin: ${plugin.name}`);
                continue;
            }
            try {
                // Initialize default config if missing
                if (!this.configs[plugin.name]) {
                    this.configs[plugin.name] = {};
                }
                // [HARDENING] Route Auditing
                // Wrap app to log route registrations
                const appWrapper = new Proxy(this.app, {
                    get: (target, prop) => {
                        if (['get', 'post', 'put', 'delete', 'patch', 'use'].includes(prop)) {
                            return (...args) => {
                                const path = typeof args[0] === 'string' ? args[0] : '(middleware)';
                                console.log(`[PluginManager] 🛡️ Plugin '${plugin.name}' registering: [${prop.toUpperCase()}] ${path}`);
                                return target[prop](...args);
                            };
                        }
                        return target[prop];
                    }
                });
                await plugin.init(appWrapper, HookSystem_js_1.hooks);
                console.log(`[PluginManager] initialized: ${plugin.name}`);
            }
            catch (error) {
                console.error(`[PluginManager] Failed to init ${plugin.name}:`, error);
            }
        }
        await this.saveStates();
        await this.saveConfigs();
    }
    /**
     * Toggle a plugin state
     */
    async togglePlugin(name, enabled) {
        this.states[name] = enabled;
        await this.saveStates();
        console.log(`[PluginManager] Plugin ${name} is now ${enabled ? 'ENABLED' : 'DISABLED'}`);
    }
    /**
     * Get list of registered plugins with status
     */
    getPlugins() {
        return this.plugins.map(p => ({
            ...p,
            status: this.states[p.name] ? 'ACTIVE' : 'INACTIVE'
        }));
    }
    async getPluginConfig(name) {
        return this.configs[name] || {};
    }
    async updatePluginConfig(name, config) {
        this.configs[name] = { ...this.configs[name], ...config };
        await this.saveConfigs();
        console.log(`[PluginManager] Updated config for ${name}`);
    }
    /**
     * Install a plugin from a zip file
     */
    async installPlugin(zipPath) {
        return new Promise(async (resolve, reject) => {
            try {
                // Dynamic import to avoid build errors if package is missing during dev
                const AdmZip = (await Promise.resolve().then(() => __importStar(require('adm-zip')))).default;
                const zip = new AdmZip(zipPath);
                // Extract directly to plugins directory
                // We assume the zip contains a folder with the plugin name
                const pluginsDir = path_1.default.join(process.cwd(), 'src', 'plugins');
                await promises_1.default.mkdir(pluginsDir, { recursive: true });
                zip.extractAllTo(pluginsDir, true);
                // Note: In production we might need to compile the TS or require a restart
                // For now, extraction is enough, user must restart.
                console.log(`[PluginManager] Extracted plugin to ${pluginsDir}`);
                resolve();
            }
            catch (err) {
                console.error('[PluginManager] Failed to install plugin:', err);
                reject(err);
            }
        });
    }
    /**
     * Get merged navigation from active plugins
     */
    getNavigation() {
        return this.plugins
            .filter(p => this.states[p.name])
            .flatMap(p => p.navigation || []);
    }
}
exports.PluginManager = PluginManager;
//# sourceMappingURL=PluginManager.js.map