import { Express } from 'express';
import { HookSystem } from './HookSystem.js';
export interface PluginDefinition {
    name: string;
    version: string;
    description?: string;
    init: (app: Express, hooks: HookSystem) => Promise<void>;
    navigation?: {
        name: string;
        href: string;
        icon: string;
        roles: string[];
    }[];
}
export declare class PluginManager {
    private plugins;
    private app;
    private stateFile;
    private states;
    constructor(app: Express);
    /**
     * Register a plugin manually
     */
    register(plugin: PluginDefinition): void;
    private loadStates;
    private saveStates;
    /**
     * Initialize all registered plugins
     */
    private configFile;
    private configs;
    private loadConfigs;
    private saveConfigs;
    init(): Promise<void>;
    /**
     * Toggle a plugin state
     */
    togglePlugin(name: string, enabled: boolean): Promise<void>;
    /**
     * Get list of registered plugins with status
     */
    getPlugins(): {
        status: string;
        name: string;
        version: string;
        description?: string;
        init: (app: Express, hooks: HookSystem) => Promise<void>;
        navigation?: {
            name: string;
            href: string;
            icon: string;
            roles: string[];
        }[];
    }[];
    getPluginConfig(name: string): Promise<any>;
    updatePluginConfig(name: string, config: any): Promise<void>;
    /**
     * Install a plugin from a zip file
     */
    installPlugin(zipPath: string): Promise<void>;
    /**
     * Get merged navigation from active plugins
     */
    getNavigation(): {
        name: string;
        href: string;
        icon: string;
        roles: string[];
    }[];
}
//# sourceMappingURL=PluginManager.d.ts.map