"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateLanguage = void 0;
const database_js_1 = __importDefault(require("../config/database.js"));
const errorHandler_js_1 = require("../middleware/errorHandler.js");
// Update user language preference
const updateLanguage = async (req, res, next) => {
    try {
        if (!req.user) {
            throw (0, errorHandler_js_1.createError)('Not authenticated', 401);
        }
        const { language } = req.body;
        if (!language || !['en', 'fr'].includes(language)) {
            throw (0, errorHandler_js_1.createError)('Invalid language. Must be "en" or "fr"', 400);
        }
        const user = await database_js_1.default.user.update({
            where: { id: req.user.id },
            data: { language },
            select: {
                id: true,
                email: true,
                language: true
            }
        });
        res.json({
            success: true,
            data: user,
            message: 'Language preference updated successfully'
        });
    }
    catch (error) {
        next(error);
    }
};
exports.updateLanguage = updateLanguage;
//# sourceMappingURL=users.controller.js.map