"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteImage = exports.uploadMultipleImages = exports.uploadImage = void 0;
const upload_service_1 = require("../services/upload.service");
/**
 * Upload single image
 */
const uploadImage = async (req, res) => {
    try {
        if (!req.file) {
            return res.status(400).json({
                success: false,
                error: {
                    message: 'No file uploaded',
                },
            });
        }
        const uploadType = req.body.uploadType || 'products';
        const fileUrl = (0, upload_service_1.getFileUrl)(req.file.filename, uploadType);
        res.status(201).json({
            success: true,
            data: {
                filename: req.file.filename,
                originalName: req.file.originalname,
                size: req.file.size,
                mimetype: req.file.mimetype,
                url: fileUrl,
            },
        });
    }
    catch (error) {
        console.error('Error uploading image:', error);
        res.status(500).json({
            success: false,
            error: {
                message: 'Failed to upload image',
            },
        });
    }
};
exports.uploadImage = uploadImage;
/**
 * Upload multiple images
 */
const uploadMultipleImages = async (req, res) => {
    try {
        if (!req.files || !Array.isArray(req.files) || req.files.length === 0) {
            return res.status(400).json({
                success: false,
                error: {
                    message: 'No files uploaded',
                },
            });
        }
        const uploadType = req.body.uploadType || 'products';
        const files = req.files.map(file => ({
            filename: file.filename,
            originalName: file.originalname,
            size: file.size,
            mimetype: file.mimetype,
            url: (0, upload_service_1.getFileUrl)(file.filename, uploadType),
        }));
        res.status(201).json({
            success: true,
            data: {
                files,
                count: files.length,
            },
        });
    }
    catch (error) {
        console.error('Error uploading images:', error);
        res.status(500).json({
            success: false,
            error: {
                message: 'Failed to upload images',
            },
        });
    }
};
exports.uploadMultipleImages = uploadMultipleImages;
/**
 * Delete image by URL
 */
const deleteImage = async (req, res) => {
    try {
        const { url } = req.body;
        if (!url) {
            return res.status(400).json({
                success: false,
                error: {
                    message: 'Image URL is required',
                },
            });
        }
        const filePath = (0, upload_service_1.getFilePathFromUrl)(url);
        if (!filePath) {
            return res.status(400).json({
                success: false,
                error: {
                    message: 'Invalid image URL',
                },
            });
        }
        await (0, upload_service_1.deleteFile)(filePath);
        res.json({
            success: true,
            message: 'Image deleted successfully',
        });
    }
    catch (error) {
        console.error('Error deleting image:', error);
        res.status(500).json({
            success: false,
            error: {
                message: 'Failed to delete image',
            },
        });
    }
};
exports.deleteImage = deleteImage;
//# sourceMappingURL=upload.controller.js.map