import { Request, Response, NextFunction } from 'express';
/**
 * Get all categories (hierarchical structure)
 */
export declare const getAllCategories: (req: Request, res: Response, next: NextFunction) => Promise<void>;
/**
 * Get single category by ID
 */
export declare const getCategoryById: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Get subcategories of a parent category
 */
export declare const getSubcategories: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Create new category
 */
export declare const createCategory: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Update category
 */
export declare const updateCategory: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Delete category
 */
export declare const deleteCategory: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Get products in a category
 */
export declare const getCategoryProducts: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
//# sourceMappingURL=category.controller.d.ts.map