import { Request, Response } from 'express';
/**
 * Get all banner slides (public - for customer shop)
 */
export declare const getAllBannerSlides: (req: Request, res: Response) => Promise<void>;
/**
 * Get all banner slides (admin - includes inactive)
 */
export declare const getAllBannerSlidesAdmin: (req: Request, res: Response) => Promise<void>;
/**
 * Get single banner slide
 */
export declare const getBannerSlide: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Create banner slide
 */
export declare const createBannerSlide: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Update banner slide
 */
export declare const updateBannerSlide: (req: Request, res: Response) => Promise<void>;
/**
 * Delete banner slide
 */
export declare const deleteBannerSlide: (req: Request, res: Response) => Promise<void>;
/**
 * Reorder banner slides
 */
export declare const reorderBannerSlides: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
//# sourceMappingURL=banner.controller.d.ts.map