"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.connectDatabase = void 0;
const client_1 = require("@prisma/client");
const prisma = new client_1.PrismaClient({
    log: process.env.NODE_ENV === 'development' ? ['query', 'error', 'warn'] : ['error'],
});
// Test database connection
const connectDatabase = async () => {
    try {
        await prisma.$connect();
        console.log('✓ Database connected successfully');
    }
    catch (error) {
        console.error('✗ Database connection failed:', error);
        process.exit(1);
    }
};
exports.connectDatabase = connectDatabase;
// Graceful shutdown
process.on('beforeExit', async () => {
    await prisma.$disconnect();
});
exports.default = prisma;
//# sourceMappingURL=database.js.map