# Cart Debugging Guide

## Problem
A specific product is always appearing in the cart, even after clearing it or refreshing the page.

## Solution
We've implemented cart debugging tools to help diagnose and fix this issue.

### Method 1: Browser Console (Easiest)

1. Open your browser at the shop page
2. Open Developer Tools (F12 or Ctrl+Shift+I)
3. Go to the Console tab
4. Copy and paste the entire contents of `public/cart-debug.js` into the console and press Enter
5. Use the following commands:

```javascript
// Check current cart contents
window.cartDebug.log()

// Clear the cart completely
window.cartDebug.clear()

// Validate cart data for issues
window.cartDebug.validate()

// Auto-fix any cart issues
window.cartDebug.fix()
```

### Method 2: Built-in Debug Functions

The app now includes debug functions that are automatically available:

```javascript
// Log cart details
window.cartDebug.log()

// Clear cart
window.cartDebug.clear()
```

### Method 3: Manual localStorage clearing

If the above methods don't work, you can manually clear the cart:

1. Open Developer Tools (F12)
2. Go to Application tab
3. Expand Local Storage
4. Select your site
5. Find and delete the `hardware-store-cart` key

## What the Fix Does

1. **Validates cart data on load** - Checks for corrupted or invalid product data
2. **Auto-clears invalid carts** - If cart has issues, it's automatically cleared
3. **Provides debugging tools** - Easy access to cart inspection and clearing
4. **Prevents future issues** - Better validation prevents corrupted data

## Steps to Fix the Persistent Cart Item

1. **Clear the cart** using one of the methods above
2. **Refresh the page** to ensure the cart stays empty
3. **Test adding products** normally
4. **Check if the issue persists**

If the problem continues after clearing, the issue might be:
- Backend returning default cart data
- Another browser tab/session interfering
- Extension or script modifying localStorage

## Technical Details

The cart is stored in localStorage under the key `hardware-store-cart`. The validation checks for:
- Proper array structure
- Valid product objects with IDs and names
- Valid quantities
- Proper cart item keys

Invalid carts are automatically cleared to prevent the persistent item issue.
