import { Request, Response } from 'express';
/**
 * Create a new order
 * POST /api/orders
 */
export declare const createOrder: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Get all orders (Admin only)
 * GET /api/orders
 */
export declare const getAllOrders: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Get order by ID
 * GET /api/orders/:id
 */
export declare const getOrderById: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Get customer's orders
 * GET /api/orders/my-orders
 */
export declare const getMyOrders: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Update order status (Admin only)
 * PUT /api/orders/:id/status
 */
export declare const updateOrderStatus: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
/**
 * Cancel order
 * PUT /api/orders/:id/cancel
 */
export declare const cancelOrder: (req: Request, res: Response) => Promise<Response<any, Record<string, any>>>;
//# sourceMappingURL=order.controller.d.ts.map